#include <cstdio>
#include <cassert>
#include <cstring>
#include <algorithm>
#include <iostream>
#include <ctime>
#include <unistd.h>
#include <vector>
#include <set>
#include <queue>
#include <string>

using namespace std;

#define FOR(i, a, b) for (int i=(a); i<(b); i++)
#define REP(i, n) FOR(i, 0, n)
#define X first
#define Y second

#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

typedef long long ll;
typedef pair<int, int> P;

const int MAX = 105, M = 101;

int e[MAX][MAX];
vector <int> Sol[MAX];
int last_p = 1;
int n, m;

int cnt=0;
void make_player(vector <P> E, int st) {
  vector <int> T;
  int bio[MAX] = {0};
  
  cnt++;
  for (auto it : E) {
    if (e[it.X][it.Y]) swap(it.X, it.Y);

    T.push_back(it.X);
    T.push_back(it.Y);    
    bio[it.X] = bio[it.Y] = 1;
  }

  FOR(i, 1, n+1) {
    if (!bio[i]) {
      if (st) T.push_back(i);
      else T.insert(T.begin(), i);
    }
  }

  for (auto it : T)
    Sol[it].push_back(last_p++);
}

int main() {
  scanf("%d%d", &n, &m);

  //0 is dummy node
  REP(i, m) {
    int a, b;
    scanf("%d%d", &a, &b);
    e[a][b] = 1;
  }

  printf("199\n"); //K
  
  FOR(raz, 1, 51) {
    vector <int> V; //starts and ends with 0    
    for (int i=0, node=0; i<=M; i++, node = (node + raz) % M)
      V.push_back(node);
    assert(V.back() == 0);

    FOR(poc, 1, 3) {
      vector <P> E;
      for (int i=poc; i<(int) V.size()-1; i+=2)
	E.push_back(P(V[i], V[i+1]));
      
      make_player(E, 1);
      
      if (raz != 50 || poc != 2) {
	reverse(E.begin(), E.end());
	make_player(E, 0);
      }
    }
  }
  
  FOR(i, 1, n+1) {
    assert(Sol[i].size() == 199);
    REP(j, 199)
      printf("%d ", Sol[i][j]);
    printf("\n");
  }  
  
  return 0;
}
